<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;
require_once(NGEPATH_HELPERS . '/api/content/data/datacustomfilter.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablecolumn.php');

/**
 * Table Cols class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportTableColumns{
	/**   
	 * @var Array $items
	 */
	public $items;
		
	
	//border backgrund	
	
	function __construct(){
		$this->items = array();
		//$this->border = xxx;		
	}
		
	public function bind($data){
		if (isset($data->count)){
			// array for parsed column aliases, used to define in an alias already exist.
			$usedColumnAliases = array();

		    $count = $data->count;

			// parse columns items
		    for ($i=0;$i<$count; $i++){

			$column = new PartReportTableColumn();
			//Bind data if column complete (field can be empty while filling the form)
			if (isset($data->items) && !(($data->items[$i]->source == 'field') && ($data->items[$i]->field == ''))){
			    $column->bind($data->items[$i]);
			    
			    //TODO to move
    			    if (!(($column->source == 'field') && ($column->field == ''))) {
			    	// by default, alias is column namespace
			    	// but alias must be unique, so look in $usedColumnAliases array for existing 
			    	//	alias, if true, generate alias composed with fieldname_1
			    	$temp_alias = $column->field;
			    	$counter=1;
			    				    	
			    	while (! (in_array($temp_alias,$usedColumnAliases,true) === false) ) {
						$temp_alias= $column->field.'_'.$counter;
						$counter++;
							
					}
					
			    	$column->alias 	= $temp_alias;
					$usedColumnAliases[] = $column->alias;
			    } 

			    
			    $this->items[] = $column;
			}
		    }
		}
	    }
	
	public function codeWizard($partObject){}
}