<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/font.php');

/**
 * Table Cols class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportTableColumnHeader extends PartBody{
		
	
	/**
	* @var String $display
	*/
	public $display;

	/**
	* @var String $source
	*/
	public $source;

	/**
	* @var String $custom
	*/
	public $custom;

	/**
	* @var String $align
	*/
	public $align;
    
	/**
	 * @var PartFont $font
	 */
	public $font;

	
	function __construct(){

		parent::__construct();
		$this->display 	= true; 
		$this->source 	= 'label'; //Label code custom, None
		$this->custom 	= ''; //Custom rich text
		$this->align	= 'left';
		$this->font = 	new PartFont();
		
	}
	
	public function bind($data){
	    
	    //Body
	    parent::bind($data);	
	
	    if (isset($data->display))		 	$this->display = 		$data->display;
	    if (isset($data->source))		 	$this->source = 		$data->source;
	    if (isset($data->custom))		 	$this->custom = 		$data->custom;
	    if (isset($data->align))		 	$this->align = 		$data->align;
	    $this->font->bind($data->font);
	}
		
	public function codeWizard($partObject){}
}