<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/sizewidthobject.php');
require_once(NGEPATH_HELPERS . '/api/content/data/datafilter.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablecolumnheader.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablecolumngroups.php');

/**
 * Table Cols class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportTableColumn extends PartBody{
		
	
    	/**
	 * @var PartReportTableColumnHeader $header
	 */
	public $header;

	/**
	* @var String $source
	*/
	public $source;

	/**
	* @var String $theme
	*/
	public $theme;

	/* @var String $field
	*/
	public $field;

	/* @var String $align
	*/
	public $align;
	
	/* @var array $filters
	*/
	public $filters;
	
	/**
	 * @var PartFont $font
	 */
	public $font;

	
	function __construct(){

		parent::__construct();
		$this->source 	= 'field'; //field, calc, custom
		$this->field 	= '';
		$this->theme	= 'custom';
		
		$this->groups 	= new PartReportTableColumnGroups();
		$this->align	= 'left';
		$this->filter	= new NgePartDataFilter();		    
		$this->header	= new PartReportTableColumnHeader();	
		$this->font = 	new PartFont();
		$this->width =  new PartSizeWidthObject();
		
	}
	
	public function bind($data){
	    
		//Body
		parent::bind($data);
		  if (isset($data->source))		 	$this->source = 		$data->source;
		  if (isset($data->field))		 	$this->field = 		$data->field;
		  if (isset($data->theme))		 	$this->theme = 		$data->theme;
		  if (isset($data->align))		 	$this->align = 		$data->align;

		  $this->filter->bind($data->filter);
		  $this->groups->bind($data->groups);
		  if (isset($data->header))	$this->header->bind($data->header);
		  if (isset($data->font))	$this->font->bind($data->font);
		  if (isset($data->width))	{
		  	$this->width->mode = $data->width->mode;
		  	$this->width->value = $data->width->fixed_value;
		  }	
	}
		
	
	public function codeWizard($partObject){}
}
