<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablecontent.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablenavigation.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablerows.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablebody.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablecolumns.php');
require_once(NGEPATH_HELPERS . '/api/content/data/datafilter.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablegroups.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDatabaseReportingTable extends NgePanel {

	/**   
	 * @var PartTablecontent $content
	 */
	public $content;
	
	/**   
	 * @var PartHeader $header
	 */
	//public $header;
	
	/**
	 * @var PartFont $font
	 */
	public $font;
			
	/**
	 * @var PartTableHeader $tableheader
	 */
	public $tableheader;
	
	/**
	 * @var PartTableRows $rows
	 */
	public $rows;
	
	/**
	 * @var PartTableCols $cols
	 */
	public $columns;

	/**
	 * @var PartDataGroups $groups
	 */
	public $groups;

	/**
	 * @var PartHeader $cols
	 */
	public $firstcol;
	
	/**
	 * @var PartTableBody $body
	 */
	public $body;
	
	/**
	 * @var PartTableNavigation $navigation
	 */
	public $navigation;
	
	/**
	 * @var NgePartDataFilter $filter
	 */
	public $filter;
	

	function __construct(){
		parent::__construct();

		$this->apiname = 'database.reporting.table';
				
		//Default values		
		$this->content = 		new PartTablecontent();
		//$this->header = 		new PartHeader();
		$this->font = 		new PartFont();
		$this->tableheader = 	new PartHeader();
		$this->rows = 		new PartReportTableRows();
		$this->columns = 		new PartReportTableColumns();
		$this->groups = 		new PartReportTableGroups();
		$this->firstcol = 		new PartHeader();
		$this->body = 		new PartReportTableBody();
		$this->navigation =		new PartReportTableNavigation();
		$this->filter =		new NgePartDataFilter();		    
	}

	//Bind params from JRegistry data object
	protected function bind($params){
	    
		//Common part properties
		parent::bind($params);
		$content = new stdClass();
		$content = $params->get('content');
		if (isset($content)){
		    $content->input = $params->get('content_input_values');
		    $content->import = $params->get('content_import_values');
		}
		$this->content->bind($content);
		//$this->header->bind($params->get('header'));
		$this->font->bind($params->get('font'));
//		$this->border->bind($params->get('border'));
//		$this->background->bind($params->get('background'));
//		$this->shadow->bind($params->get('shadow'));
		$this->tableheader->bind($params->get('tableheader'));
		$this->rows->bind($params->get('rows'));
		$this->columns->bind($params->get('columns'));
		$this->groups->bind($params->get('groups'));
		$this->firstcol->bind($params->get('firstcol'));
		$this->body->bind($params->get('body'));
		$this->navigation->bind($params->get('navigation'));
		$this->filter->bind($params->get('filter'));
						
	}

	public function codeWizard($partObject){}
}