<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/data/datacontent.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablecolumns.php');
require_once(NGEPATH_HELPERS . '/api/content/data/datafilter.php');
require_once(NGEPATH_HELPERS . '/api/content/data/datagroups.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDatabaseReportingData extends NgePart {

	/**   
	 * @var PartTablecontent $content
	 */
	public $content;
	
	/**   
	 * @var PartHeader $header
	 */
	//public $header;
				
	/**
	 * @var PartTableCols $cols
	 */
	public $columns;

	/**
	 * @var PartDataGroups $groups
	 */
	public $groups;
		
	/**
	 * @var NgePartDataFilter $filter
	 */
	public $filter;
	

	function __construct(){
		parent::__construct();

		$this->apiname = 'database.reporting.data';
				
		//Default values		
		$this->content = 		new PartDatacontent();
		$this->columns = 		new PartReportTableColumns();
		$this->groups = 		new PartReportDataGroups();
		$this->filter =		new NgePartDataFilter();		    
	}

	//Bind params from JRegistry data object
	protected function bind($params){
	    
		//Common part properties
		parent::bind($params);
		$content = new stdClass();
		$content = $params->get('content');
		if (isset($content)){
		    $content->input = $params->get('content_input_values');
		    $content->import = $params->get('content_import_values');
		}
		$this->content->bind($content);
		//$this->header->bind($params->get('header'));
		$this->columns->bind($params->get('columns'));
		$this->groups->bind($params->get('groups'));
		$this->filter->bind($params->get('filter'));
						
	}

	public function codeWizard($partObject){}
}