<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/database/reporting/chart/chartseriesgroupingtotal.php');

/**
 * Table Cols class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportChartSeriesGrouping {
		
		
	/* @var String $field
	*/
	public $field;
	
	/* @var PartReportChartSeriesGroupingTotal $total
	*/
	public $total;
	
	/* @var String $type
	*/
	public $type;
	
	/* @var String $dashstyle
	*/
	public $dashstyle;
	
	/* @var String $stacking
	*/
	public $stacking;

	function __construct(){

		$this->field	= '';
		$this->datafield= '';
		$this->total	= new PartReportChartSeriesGroupingTotal();
		
		$this->type	= 'line';
		$this->dashstyle	= 'dashstyle';
		$this->stacking	= 'none';
	}
	
	public function bind($data){

	    if (isset($data->field))	$this->field =	$data->field;
	    if (isset($data->datafield))	$this->datafield =	$data->datafield;
	    $this->total->bind($data->total);
	    
	    if (isset($data->type))	$this->type =	$data->type;
	    if (isset($data->dashstyle))	$this->dashstyle =	$data->dashstyle;
	    if (isset($data->stacking))	$this->stacking =	$data->stacking;
	    
	}
			
	public function codeWizard($partObject){}
}