<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;
require_once(NGEPATH_HELPERS . '/api/content/data/datacustomfilter.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/chart/chartserie.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/chart/chartseriesgrouping.php');

/**
 * Table Cols class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportChartSeries{

    
    	/**   
	 * @var String $mode
	 */
	public $mode;

	/**   
	 * @var Array $items
	 */
	public $items;
		
	
	//border backgrund	
	
	function __construct(){
	    
		$this->mode = 'grouping'; //grouping ou custom
		$this->grouping = new PartReportChartSeriesGrouping();
			
		$this->items = array();
		//$this->border = xxx;		
	}
		
	public function bind($data){
	    
		if (isset($data->mode))	$this->mode = $data->mode;
		$this->grouping->bind($data->grouping);
	    
		//Custom mode
		if (isset($data->count)){
			// array for parsed column aliases, used to define in an alias already exist.
			$usedColumnAliases = array();

		    $count = $data->count;

			// parse columns items
		    for ($i=0;$i<$count; $i++){

				$serie = new PartReportChartSerie();
				//Bind data if column complete (field can be empty while filling the form)
				if (isset($data->items) && isset($data->items[$i])) {
					
				    $serie->bind($data->items[$i]);
				    
				    
    			    if (($serie->source == 'field') && ($serie->field != '')) {
				    	// by default, alias is column namespace
				    	// but alias must be unique, so look in $usedColumnAliases array for existing 
				    	//	alias, if true, generate alias composed with fieldname_1
				    	$temp_alias = $serie->field;
				    	$counter=1;
				    				    	
				    	while (! (in_array($temp_alias,$usedColumnAliases,true) === false) ) {
							$temp_alias= $serie->field.'_'.$counter;
							$counter++;
								
						}
						
				    	$serie->alias 	= $temp_alias;
						$usedColumnAliases[] = $serie->alias;
						
						$this->items[] = $serie;
			       } 

				   if ($serie->source == 'custom') {
				    	// by default, alias is column namespace
				    	// but alias must be unique, so look in $usedColumnAliases array for existing 
				    	//	alias, if true, generate alias composed with fieldname_1
				    	$temp_alias = 'custom';
				    	$counter=1;
				    				    	
				    	while (! (in_array($temp_alias,$usedColumnAliases,true) === false) ) {
							$temp_alias= 'custom_'.$counter;
							$counter++;
								
						}
						
				    	$serie->alias 	= $temp_alias;
						$usedColumnAliases[] = $serie->alias;
						
						$this->items[] = $serie;
			       }  
				    
				}
		    }
		}
	    }
	
	public function codeWizard($partObject){}
}