<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/data/datafilter.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/chart/chartseriename.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablecolumngroups.php');

/**
 * Table Cols class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartReportChartSerie {
		
	
	/**
	* @var String $source
	*/
	public $source;


	/* @var String $field
	*/
	public $field;

	/* @var array $filters
	*/
	public $filters;
	
	/* @var String $type
	*/
	public $type;
	
	/* @var String $stacking
	*/
	public $stacking;
	
	/* @var String $axis 
	 * default or new
	*/
	public $axis;

	/* @var String $color
	*/
	public $color;
	
	/* @var String $dashstyle
	*/
	public $dashstyle;

	/* @var String $customdata
	*/
	public $customdata;
	
	function __construct(){
		
		//Nge properties
		$this->source 	= 'field'; //field, calc, custom
		$this->field 	= '';
		$this->groups 	= new PartReportTableColumnGroups();
		$this->filter	= new NgePartDataFilter();
		$this->name	= new PartReportChartSerieName();
				
		//Highchart properties : same as Highchart serie
		$this->type	= '';
		$this->stacking	= 'None';
		$this->color	= '';
		$this->dashstyle	= 'Solid';

		$this->axis	= 'default';
		
		$this->customdata = array();
		
	}
	
	public function bind($data){
	    
		  if (isset($data->source))		 	$this->source = 		$data->source;
		  if (isset($data->field))		 	$this->field = 		$data->field;

		  $this->filter->bind($data->filter);
		  $this->groups->bind($data->groups);
		  $this->name->bind($data->name);

		  if (isset($data->type))		 	$this->type = 		$data->type;
		  if (isset($data->stacking))		 	$this->stacking = 		$data->stacking;
		  if (isset($data->color))		 	$this->color = 		$data->color;
		  if (isset($data->dashstyle))		 	$this->dashstyle = 		$data->dashstyle;
		  if (isset($data->axis))		 	$this->axis = 		$data->axis;
		  if (isset($data->customdata))		 	$this->customdata = 	$data->customdata;
		  
	}
			
	public function codeWizard($partObject){}
}