<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablerows.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/table/tablebody.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/chart/chartseries.php');
require_once(NGEPATH_HELPERS . '/api/content/data/datafilter.php');
require_once(NGEPATH_HELPERS . '/api/part/database/reporting/chart/chartgroup.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDatabaseReportingChart extends NgePanel {

	
	/**
	 * @var PartChartSeries $series
	 */
	public $series;

	/**
	 * @var PartDataGroups $groups
	 */
	public $groups;
	
	
	/**
	 * @var NgePartDataFilter $filter
	 */
	public $filter;
	
	/**
	 * @var PartDataGroups $xAxis
	 */
	public $xAxis;


	function __construct(){
		parent::__construct();

		$this->apiname = 'database.reporting.chart';
				
		//Default values		
		$this->filter =		new NgePartDataFilter();
		$this->series = 		new PartReportChartSeries();
		$this->group = 		new PartReportChartGroup();
		$this->xAxis = array();

	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		$this->series->bind($params->get('series'));
		$this->group->bind($params->get('group'));
		$this->filter->bind($params->get('filter'));
		$this->xAxis = $params->get('xAxis');
						
	}

	public function codeWizard($partObject){}
}