<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/sizewidthobject.php');
require_once(NGEPATH_HELPERS . '/api/body.php');

/**
 * Caption class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSearch extends PartBody{    

    	/**
	* @var String $style
	 *  pattern, custom
	 */
	public $style;

    
	/**
	 * @var String $html
	 */
	public $html;
	
	/**
	 * @var String $position
	 */
	public $position;
	
	/**
	 * @var String $align
	 */
	public $align;
	
	/**
	 * @var String $valign
	 */
	public $valign;
	
	/**
	 * @var PartSizeWidthObject $sidewidth
	 */
	public $sidewidth;
	
	/**
	 * @var array $effects
	 */
	public $effects;

	
	function __construct($preset = null){

	    	parent::__construct();
		
		$this->style = 'custom';
		
		$this->html = 		'';
		$this->position = 		'bottom';
		$this->align = 		'left';
		$this->valign = 		'top';
		$this->sidewidth =		new PartSizeWidthObject('bootstrap');
		$this->effects		= array();
	}
	
	public function bind($data){

		parent::bind($data);
	    
		 //Content
		if (isset ( $data->html ))		$this->html = $data->html;				

		//Options
		if (isset($data->style))    $this->style = $data->style;

		if (($this->style == 'pattern') && (isset($data->pattern))){	
		    $patternId = $data->pattern;
		    if ($data->pattern != '')
			$data = $this->loadPattern($data->pattern);		    
		}

		if (($this->style == 'custom') || (($this->style == 'pattern') && ($patternId != ''))){		    
		    
		    if (isset ( $data->position ))		$this->position = $data->position;
		    if (isset ( $data->align ))		$this->align = $data->align;
		    if (isset ( $data->valign ))		$this->valign = $data->valign;

		    if (isset ( $data->sidewidth))		$this->sidewidth->bind ( $data->sidewidth );

		    //display effects on display trigger
		    if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action != 'none')){
			$effect = new PartDisplayEffect();
			$effect->bind($data->effects->display);
			$effect->event='display';
			$this->effects[] = $effect;
		    }
		    //display effects on hover trigger
		    if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action != 'none')){
			$effect = new PartDisplayEffect();
			$effect->bind($data->effects->hover);
			$effect->event='hover';
			$this->effects[] = $effect;
		    }
		}
	}
	
	public function codeWizard($partObject){}
}
