<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS . '/api/content/datacontent.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/tooltip.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDataSearchInputSelect extends NgeItem{

	/**   
	 * @var String $label
	 * Shortcut for html content
	 */
	public $label;
	
	/**   
	 * @var String $placeholder
	 * Shortcut for html content
	 */
	public $placeholder;
	
	
	/**
	 * @var PartLabelContent $content
	 * 
	 */
	public $content;
		
	/**   
	 * @var PartFont $font   
	 */
	public $font;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;
	
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'data.search.input.select';
				
		//Default values		
		$this->content = 		new PartDataContent();
		$this->label = 		'';
		$this->placeholder = 		'';
		$this->font = 		new PartFont();
		$this->popover = 		new PartPopover();
		$this->size->display =	'inline';
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);

		//No content in the config screen
		$this->label = 			$params->get('label');
		$this->placeholder = 			$params->get('placeholder');		
		$this->content->bind($params->get('content'));		
		$this->font->bind($params->get('font'));		
		$this->popover->bind($params->get('popover'));	
	}

	public function codeWizard($partObject){
		$params = new JRegistry;
		$params->loadString($partObject->params);
		//If defined, load default pattern
		if ($params->get('pattern') != '')
			$this->loadPattern($params->get('pattern'));
		
		$html[] = "";
		$html[] = "//Part creation. Generated from source code wizard ";
		$html[] = "//$"."part = NgeHelper::create('text.label');";
		$html[] = "$"."part = new NgeTextLabel();";
		$html[] = "$"."part->id = rand();";

		//Content
		if ($params->get('source')  != $this->source) 
			$html[] = "$"."part>source = \"\t\t".$params->get('source')."\";";
		
		if (($params->get('source')  == 'text') && ($params->get('text') != $this->text))
			$html[] = "$"."part->text = \"\t\t".$params->get('text')."\";";
		
		//Style
		if ($params->get('style') != $this->style){
			$html[] = '$'.'part->style = "'.$params->get('style').'";';
			if (in_array($params->get('style'), array('label', 'badge'))){
				$html = array_merge($html , $this->codeCompare('theme', $params->get('theme')));
			}
			else
			if ($params->get('style') == 'custom'){
				//TODO ne fonctionne pas
				$html = array_merge($html , $this->codeCompare('custom_color', $params->get('custom_color')));
			}
		}

		//Font
		$html = array_merge($html, $this->font->codeWizard($partObject));
	
		$html[] = '';


		//TODO display
		// $data->display = 			$params->get('display');
		// $data->access = 			$params->get('access');
	
	
		$html[] = "//Rendering";
		$html[] = "$"."part->display();";
		//return implode("\r\n", $html);
		return nl2br(implode("\r\n", $html));
	}
	

}
