<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS . '/api/content/datacontent.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDataSearchInputCheckbox extends NgeItem{

	/**   
	 * @var String $label
	 * Shortcut for html content
	 */
	public $label;
		
	/**
	 * @var PartLabelContent $content
	 * 
	 */
	public $content;
		
	/**   
	 * @var PartFont $font   
	 */
	public $font;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;
	
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'data.search.input.checkbox';
				
		//Default values		
		$this->content = 	new PartDataContent();
		$this->label = 	'';
		$this->font = 	new PartFont();
		$this->popover = 		new PartPopover();
		$this->size->display =	'inline';
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);

		//No content in the config screen
		$this->label = 	$params->get('label');
		$this->content->bind($params->get('content'));		
		$this->font->bind($params->get('font'));		
		$this->popover->bind($params->get('popover'));	
	}


}
