<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS . '/api/content/datacontent.php');

require_once(NGEPATH_HELPERS . '/api/bar.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/buttonbar/barbuttons.php');


/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDataSearchInputButtons extends NgeItem{

	/**   
	 * @var String $label
	 * Shortcut for html content
	 */
	public $label;
		
	/**
	 * @var PartLabelContent $content
	 * 
	 */
	public $content;
		
	/**   
	 * @var PartBar $bar
	 */
	public $bar;
	
	/**   
	 * @var PartButton $button   
	 */
	public $buttons;		
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;
		
	function __construct(){
		parent::__construct();

		$this->apiname = 'data.search.input.buttons';
				
		//Default values		
		$this->content = 	new PartDataContent();
		$this->label = 	'';
		
		$this->bar =	new PartBar();	
		$this->buttons =	new PartBarButtons();	
		
		$this->popover = 		new PartPopover();
		$this->size->display =	'inline';
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);

		//No content in the config screen
		$this->label = 	$params->get('label');
		$this->content->bind($params->get('content'));		

		$this->bar->bind($params->get('bar'));	
		$this->buttons->bind($params->get('buttons'));
		
		$this->popover->bind($params->get('popover'));	
	}

}
