<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/content/labelcontent.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/tooltip.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');

/**
 * Label class
 * @package 	Content
 * @subpackage  Text
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDataProgress extends NgePart{

	/**   
	 * @var String $text   
	 * Shortcut for html content
	 */
	public $label;
	
	/**
	 * @var PartLabelContent $content
	 * 
	 */
	public $content;
	
	/**   
	 * @var String $style   
	 */
	public $style;
	
	/**   
	 * @var String $theme   
	 */
	public $theme;
	
	/**   
	 * @var PartFont $font   
	 */
	public $font;
	
	/**   
	 * @var PartTooltip $tooltip   
	 */
	public $tooltip;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;
	
	/**   
	 * @var String $custom_color   
	 */
	public $custom_color;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'data.progress';
				
		//Default values		
		$this->content = 		new PartLabelContent();
		$this->label = 			'';
		$this->style = 			'text';
		$this->theme = 		'default';
		$this->font = 			new PartFont();
		$this->tooltip = 		new PartTooltip();
		$this->popover = 		new PartPopover();
		$this->custom_color = 	"#aaaaaa";
		$this->size->display =	'inline';
	}

	//Bind params from JRegistry data object
	protected function bind($params){		
		//Common part properties
		parent::bind($params);

		//No content in the config screen
		$this->label = 			$params->get('label');
		$this->content->bind($params->get('content'));		
		$this->style = 			$params->get('style');
		$this->theme = 		$params->get('theme');
		$this->font->bind($params->get('font'));		
		$this->tooltip->bind($params->get('tooltip'));	
		$this->popover->bind($params->get('popover'));	
		$this->custom_color = 	$params->get('custom_color');
	}

	public function codeWizard($partObject){
	}
	

}
