<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tabletable.php');
require_once(NGEPATH_HELPERS . '/api/part/data/search/search.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDataDisplayTable extends NgePanel {

	/**   
	 * @var PartTablecontent $content
	 */
	public $content;
	
	/**
	 * @var PartTableTable $table
	 */
	public $table;
	
	
	/**
	 * @var PartTableNavigation $navigation
	 */
	public $navigation;

	function __construct(){
		parent::__construct();

		$this->apiname = 'data.display.table';
				
		//Default values	
		$this->content = 		new PartTablecontent();
		$this->table =		new PartTableTable();
		$this->search =		new PartSearch();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);

		$this->content->bind($params->get('content'));
		$this->table->bind($params->get('table'));
		$this->search->bind($params->get('search'));
	}

	public function codeWizard($partObject){}
}