<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnails.php');
require_once(NGEPATH_HELPERS . '/api/part/data/search/search.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnaillayout.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartDataDisplayList extends NgePanel {

	/**   
	 * @var PartTablecontent $content
	 */
	public $content;
	
	/**   
	 * @var PartThumbnailsgeneral $thumbnail
	 */
	public $thumbnails;

	function __construct(){
		parent::__construct();

		$this->apiname = 'data.display.list';
				
		//Default values	
		$this->content = 		new PartTablecontent();
		$this->search =		new PartSearch();
		$this->layout =		new PartThumbnailLayout();
		
		$this->thumbnails = 	new PartThumbnails();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);

		/*$content = new stdClass();
		$content = $params->get('content');
		if (isset($content)){
		    $content->input = $params->get('content_input_values');
		    $content->import = $params->get('content_import_values');
		}
		$this->content->bind($content);*/
		$this->content->bind($params->get('content'));
		$this->search->bind($params->get('search'));
		$this->layout->bind($params->get('layout'));
		
		$this->thumbnails->bind($params->get('thumbnails'));
	}

	public function codeWizard($partObject){}
}