<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Part API Master class
 * @package     CORE
 * @version		1.0.0
 * @since       1.0.0
 */
 
require_once NGEPATH_HELPERS . '/ngecontenthelper.php'; // used in part's layouts
require_once(NGEPATH_HELPERS . '/api/rendering.php');
require_once(NGEPATH_HELPERS . '/api/display.php');
require_once(NGEPATH_HELPERS . '/api/margin.php');
require_once(NGEPATH_HELPERS . '/api/access.php');
require_once(NGEPATH_HELPERS . '/api/publish.php');
require_once(NGEPATH_HELPERS . '/api/renderer.php');
require_once(NGEPATH_HELPERS . '/api/display/scrollbar.php');
require_once(NGEPATH_HELPERS . '/api/display/parallax.php');
require_once(NGEPATH_HELPERS . '/api/effects/displayeffect.php');

abstract class NgePart{
	
	/**   
	 *	Name of the api
	 *	@var String $apiname   
	*/
	public $apiname;
	
	/**   
	 *	Name of the original part (when used by config screen)
	 *	@var String $name
	*/
	public $name;
	
	/**   
	 *	Id of the part
	 *	@var Integer $name   
	*/
	public $id;

	/**   
	 *	Javascript content to be rendered in a script tag inside the part
 	 *	@var String $scripts
	*/
	public $script;

	/**   
	 *	Css content to be rendered in a script tag inside the part
 	 *	@var String $styles
	*/
	public $style;
	
	/**   
	 *	Name of the part type
	 *	@var String $libraryTitle  
	*/	
	public $libraryTitle;
	
	/**   
	 *	Type of pattern use to display the part
	 *	@var String $pattern   
	*/
	public $pattern;
	/**   
	 *	Type of pattern use to display the part
	 *	@var String $rendering   
	*/
	public $rendering;
	/**   
	 *	Type of pattern use to display the part
	 *	@var String $display   
	*/
	public $display;
	
	/**   
	 *	Scrollbar settings if height mode is custom
	 *	@var PartScrollbar $scrollbar
	*/
	public $scrollbar;
	
	/**   
	 *	Parallax settings if height mode is custom
	 *	@var PartParallax $parallax
	*/
	public $parallax;
        
        	/**   
	 *	Renderer engine options
	 *	@var PartRenderer $renderer
	*/
	public $renderer;
       
	public $_align;
	
	
	/**   
	 *	Type of pattern use to display the part
	 *	@var String $access   
	*/
	public $access;
	/**   
	 *	Type of pattern use to display the part
	 *	@var String $publish   
	*/
	public $publish;

	/**
	 *	Current pack version
	 *	@var String $version
	 */
	public $version;
	
	/**   
	 *	Array of optionnal attributes in the main tag
	 *	@var array; associative array
	 *  for example $this->attributes['data-toolbar'] = "edit generate";
	*/
	public $attributes;
	
	/**
	 * @var array $effects
	 */
	public $effects;
	
	
	/**
	 * External libraries paths
	 * @var array $libraries
	 */
	public $libraries;
	

	
	public function __construct(){
		$this->id = 		rand();
		$this->libraryTitle = 		'';
		$this->pattern = 	''; //Default no pattern
		$this->script = array();
		$this->style = array();
		$this->cache =	new stdClass();
		$this->cache->html = '';
		$this->cache->css = '';
		$this->cache->js = '';
 		$this->rendering = 	new PartRendering();
 		$this->display = 	new PartDisplay();
		$this->scrollbar = 	new PartScrollbar();
		$this->parallax = 	new PartParallax();
 		$this->access = 	new PartAccess();
 		$this->publish = 	new PartPublish();
		$this->renderer = 	new PartRenderer();
		$this->version 	= 	"";
		$this->attributes 	= 	array();
                $this->effects		= array();
		$this->libraries		= array();
		$this->created_by = 	'';
		
 		$this->_display = 'block';
 		$this->_align = 'left';	
		
		//Default libraries loaded from the current Joomla.
		//Can be overriden when rendering a widget to call libraries from others urls
		$this->libraries['highcharts.highcharts.js'] =		NGEURL_MEDIA . 'highcharts/js/highcharts.js';
		$this->libraries['highcharts.highcharts-more.js'] =     NGEURL_MEDIA . 'highcharts/js/highcharts-more.js';
		$this->libraries['highcharts.highcharts-3d.js'] =       NGEURL_MEDIA . 'highcharts/js/highcharts-3d.js';
		$this->libraries['highcharts.languages.'.JFactory::getLanguage()->getTag().'.js'] = NGEURL_MEDIA . 'highcharts/js/languages/'.JFactory::getLanguage()->getTag().'.js';
                $this->libraries['highcharts.modules.stock.js'] =	NGEURL_MEDIA . 'highcharts/js/modules/stock.js';
		$this->libraries['highcharts.modules.annotations.js'] = NGEURL_MEDIA . 'highcharts/js/modules/annotations.js';
		$this->libraries['highcharts.modules.exporting.js']  =  NGEURL_MEDIA . 'highcharts/js/modules/exporting.js';
                $this->libraries['highcharts.ngehighcharts.js'] =     	NGEURL_MEDIA . 'nge/ngehighcharts.js';
                $this->libraries['datatables.datatables.min.css'] =     NGEURL_MEDIA.'datatables/ngedatatables.min.css';
                $this->libraries['datatables.datatables.min.js'] =     	NGEURL_MEDIA.'datatables/datatables.min.js';
                $this->libraries['datatables.languages.'.JFactory::getLanguage()->getTag().'.js'] = NGEURL_MEDIA.'datatables/languages/'.JFactory::getLanguage()->getTag().'.js';
                $this->libraries['datatables.ngedatatable.js'] =     	NGEURL_MEDIA.'nge/ngedatatable.js';
                $this->libraries['tables.ngetables.js'] =               NGEURL_MEDIA.'nge/ngetables.js';
                $this->libraries['slick.slick.js'] =			NGEURL_MEDIA . 'slick/slick.min.js';
		$this->libraries['slick.slick.css'] =			NGEURL_MEDIA . 'slick/slick.css';
		$this->libraries['slick.slick-theme.css'] =		NGEURL_MEDIA . 'slick/slick-theme.css';
		
		
	}

	/*
	 * Compare properties for code Wizard
	 */
	protected function codeCompare($defaultPropertyName, $newProperty, $baseName ='part->', $subDefaultProperties = array(), $subNewProperties = array()){
		$html = array();
		
		if ($subDefaultProperties != array()) { //there is sub properties
			if ($subNewProperties == array())
				$subNewProperties = $subDefaultProperties;
			for ($i = 0; $i<count($subNewProperties); $i++) {
				$subDefaultProperty = $subDefaultProperties[$i];
				$subNewProperty = $subNewProperties[$i];
				if ($defaultPropertyName != '') {
					if ($this->$defaultPropertyName->$subDefaultProperty != $newProperty->$subNewProperty) 
						$html[] = '$'.$baseName.$defaultPropertyName.'->'.$subDefaultProperty .' = '."\t\t".'"'.$newProperty->$subNewProperty.'";';
				}		
				else {
					if ($this->$subDefaultProperty != $newProperty->$subNewProperty)
						$html[] = '$'.$baseName.$defaultPropertyName.'->'.$subDefaultProperty .' = '."\t\t".'"'.$newProperty->$subNewProperty.'";';						
				}						
			}
		}	
		else
		if ($this->$defaultPropertyName != $newProperty)
			$html[] = '$'.'part->'.$defaultPropertyName .' = "'.$newProperty.'";';
				
		return $html;
	}
		
	//Load an option pattern
	//This loads only the params part of the pattern, not the sample content
	private function loadPattern($patternId){

	    require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php'; 
	    $pattern = NgePatternDriver::load($patternId);
	    if (isset($pattern->params)){
		return $pattern->params;
            }else{
		return '';
            }
	}

	//Load existing part
	public function loadPart($partObject){

		if(isset($partObject->id) && $partObject->id != 0){
			$this->id = $partObject->id;
		}else{
			$this->id = rand();
		}
		
		$libraryTitle = isset($partObject->library_title)? $partObject->library_title : '';
		$this->title = (isset($partObject->title) && ($partObject->title != '')) ? $partObject->title : $libraryTitle;
		if (isset($partObject->library_title))	$this->libraryTitle = $partObject->library_title;
		if (isset($partObject->name))		$this->name = $partObject->name;
		if (isset($partObject->version))		$this->version = $partObject->version;
		if (isset($partObject->rendering))		$this->rendering->bind($partObject->rendering);
		if (isset($partObject->html))		$this->cache->html = $partObject->html;
		if (isset($partObject->css))		$this->cache->css = $partObject->css;
		if (isset($partObject->js))		$this->cache->js = $partObject->js;
		if (isset($partObject->created_by))	$this->created_by = $partObject->created_by;

		$partParamsRegistry = new JRegistry;
		$partParamsRegistry->loadString($partObject->params);
                
	                //LOAD PATTERN according to his source
		$options = $partParamsRegistry->get('options');
		$partParamsArray = json_decode($partObject->params, true);
                
		if(isset($options->source)){
		    switch ($options->source) {
			case 'pattern':
			    $patternId = (isset($options->pattern)) ? $options->pattern : "";
			    //If pattern id exist. Load the pattern properties and replace params by this one
			    if($patternId !== ""){
				$patternParamsArray = json_decode($this->loadPattern($patternId), true);
				$mergedParamsArray = NGE::array_merge_recursive_replace($partParamsArray, $patternParamsArray);

				$mergedParams = json_encode($mergedParamsArray);
				$partParamsRegistry->loadString($mergedParams);
			    }
			    break;
		    }
		}
		
		//Binding params in the current class		
		$this->bind($partParamsRegistry);
	}

	private function bindParams($paramString){
		$params = new JRegistry;
		$params->loadString($paramString);
		$this->bind($params);
	}

	/**
	 * bind data from Object (JRegistry Object)
	 */
	protected function bind($params){
		$this->display->bind($params->get('display'));
		$this->access->bind($params->get('access'));
		$this->publish->bind($params->get('publish'));
		$this->renderer->bind($params->get('renderer'));
		/*
		$current_version = $params->get('nge_current_version');
		if($current_version != null){
			$this->version	= $current_version;
		}else{
			$this->version	= $params->get('ngeversion');
		}
*/

		$this->scrollbar->bind($params->get('scrollbar'));
		$this->parallax->bind($params->get('parallax'));
		
		$this->_display = $params->get('_display');
		$this->_align = $params->get('_align');
		
		$dataEffects = $params->get('effects');
		//display effects on display trigger
		if (isset($dataEffects->display) && ($dataEffects->display->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($dataEffects->display);
		    $effect->event='display';
		    $this->effects[] = $effect;
		}
		//display effects on hover trigger
		if (isset($dataEffects->hover) && ($dataEffects->hover->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($dataEffects->hover);
		    $effect->event='hover';
		    $this->effects[] = $effect;
		}		
	}	
	
	public function display(){
		echo $this->render();
	}

	public function render(){
		//If edit mode, check user access to edit
		if ($this->created_by != '')	
		    $this->rendering->check($this->id, $this->created_by);
		//Rendering
		return NGE::layout('nge.parts.'.$this->apiname, $this);
	}
}
