<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/panelsize.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/panel/panelbody.php');
require_once(NGEPATH_HELPERS . '/api/header.php');
require_once(NGEPATH_HELPERS . '/api/legend.php');
require_once(NGEPATH_HELPERS . '/api/badge.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');

/**
  * Panel class
 * parent of all parts that have panel display
 * See also NgeItem class
 * @package 	Content
 * @subpackage  Panels/Panel
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePanel extends NgePart {

    	/**   
	 *	Size and display options
	 *	@var PartSize $size   
	*/
	public $size;
    
	/**   
	 * @var PartCustomcontent $content
	 */
	public $content;
	
	/**   
	 * @var PartPanelbody $body
	 */
	public $body;
	
	/**   
	 * @var PartHeader $header
	 */
	public $header;
	
	/**   
	 * @var parLegend $legend   
	 * Legend content and options
	 */
	public $legend;
	
	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;
	
 	/**   
 	 * @var PartBadge $badge
 	 */
 	public $badge;
	
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;

	function __construct(){
		parent::__construct();

		$this->apiname = 'panels.panel';
				
		//Default values		
		$this->body = 	new PartPanelbody();	
		$this->header = 	new PartHeader();
		$this->legend = 	new PartLegend();
		$this->badge = 	new PartBadge();
		$this->border = 	new PartBorder();
		$this->background = new PartBackground();
		$this->shadow = 	new PartShadow();
		$this->size = 	new PartPanelSize();
		
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		$this->size->bind($params->get('size'), $params->get('ngeversion'));
		$this->body->bind($params->get('body'));
		$this->header->bind($params->get('header'));
		$this->legend->bind($params->get('legend'));	
		$this->badge->bind($params->get('badge'));
		$this->border->bind($params->get('border'));
		$this->background->bind($params->get('background'));
		$this->shadow->bind($params->get('shadow'));
	}

	public function codeWizard($partObject){}
}