<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Display class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartPadding{
	
	public $default; //Default padding, for all positions (equals css "padding")
	public $left; //Left padding, overrides default value
	public $top; //Top padding, overrides default value
	public $bottom; //Bottom padding, overrides default value
	public $right; //Right padding, overrides default value
	
	function __construct(){
		
		$this->default = 		'';
		$this->left = 		'';
		$this->top =		'';
		$this->bottom =		'';
		$this->right =      '';
	}
	
	public function bind($data){
	    	//If string value, this means the params propery is silmply "padding", 
		if (isset($data) && is_string($data))	$this->default = 		$data;
	
		if (isset($data->default))	$this->default = 	$data->default;
		if (isset($data->left))	$this->left = 		$data->left;
		if (isset($data->top))	$this->top =		$data->top;
		if (isset($data->bottom))	$this->bottom =	$data->bottom;
		if (isset($data->right))	$this->right =		$data->right;		
		
	}
	
	public function codeWizard($partObject){}
}
