<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartOverflow{
	
	/** 
	 *	@var String $mode
	 *	none / background / all
	 */
	public $mode;
	
	/** 
	 *	@var String $direction
	 *	both / left / right
	 */
	public $direction;
	
	/** 
	 *	@var int $width
	 *	Width of the overflow in percentage
	 */
	public $width;
	
	function __construct(){
		$this->mode =			'none'; 
		$this->direction =			'both';
		$this->width =			'100';
	}
	
	public function bind($data){
		if (isset($data->mode))	$this->mode =	$data->mode;
		if (isset($data->direction))	$this->direction =	$data->direction;
		if (isset($data->width))	$this->width =	$data->width;
	}
	
	public function codeWizard($partObject){}
}
