<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;
require_once(NGEPATH_HELPERS . '/api/itemheight.php');
require_once(NGEPATH_HELPERS . '/api/items.php');
require_once(NGEPATH_HELPERS . '/api/bullets.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartListItems extends PartItems{
	
	/**
	 * @var PartItemheight $height
	 */
	public $height;
	

	/**
	 * @var PartBullets $bullet
	 */
	public $bullet;
		
	
	function __construct($preset = null){

		parent::__construct();
		$this->bullet =		new PartBullets();		
		$this->height =		new PartItemheight();
	}
	
	public function bind($data){

		parent::bind($data);
		if (isset($data->bullet))		$this->bullet->bind ( $data->bullet );
		if (isset($data->height))		$this->height->bind($data->height);		
	}
	
	public function codeWizard($partObject){}
}
