<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

//require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/padding.php');
require_once(NGEPATH_HELPERS . '/api/sizewidthobject.php');
require_once(NGEPATH_HELPERS . '/api/partproperty.php');

/**
 * Caption class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartLegend extends NgePartProperty{    

    	/**
	* @var String $style
	 *  pattern, custom
	 */
	public $style;

    
	/**
	 * @var String $html
	 */
	public $html;

	/**
	 * @var PartFont $font
	 */
	public $font;
			
		/**
	 * @var PartBorder $border
	 */
	public $border;

	/**
	 * @var PartBackground $background
	 */
	public $background;
		
	/**
	 * @var String $trigger
	 */
	public $trigger;
	
	/**
	 * @var String $position
	 */
	public $position;
	
	/**
	 * @var String $align
	 */
	public $align;
	
	/**
	 * @var String $valign
	 */
	public $valign;
	
	/**
	 * @var PartSizeWidthObject $sidewidth
	 */
	public $sidewidth;
	
	/**
	 * @var PartPadding $padding
	 */
	public $padding;

	/**
	 * @var array $effects
	 */
	public $effects;

	
	function __construct($preset = null){

	    	parent::__construct();
		
		$this->style = 'custom';
		
		$this->html = 		'';
		$this->font =		new PartFont();
		$this->padding = 		new PartPadding();
		$this->padding->top = 8;
		$this->padding->bottom = 8;
		$this->padding->left = 12;
		$this->padding->right = 12;
		$this->trigger = 		'always';
		$this->position = 		'bottom';
		$this->align = 		'left';
		$this->valign = 		'top';
		$this->sidewidth =		new PartSizeWidthObject('bootstrap');
		$this->border =		new PartBorder();
		$this->background =		new PartBackground();
		$this->effects		= array();
	}
	
	public function bind($data){

		 //Content
		if (isset ( $data->html ))		$this->html = $data->html;				

		//Options
		if (isset($data->style))    $this->style = $data->style;

		if (($this->style == 'pattern') && (isset($data->pattern))){	
		    $patternId = $data->pattern;
		    if ($data->pattern != '')
			$data = $this->loadPattern($data->pattern);		    
		}

		if (($this->style == 'custom') || (($this->style == 'pattern') && ($patternId != ''))){		    
		    
		    if (isset ( $data->font ))		$this->font->bind ( $data->font );
		    
		    if(isset($data->hpadding)){
			    $this->padding->left =		$data->hpadding;
			    $this->padding->right =		$data->hpadding;
		    }
		    if(isset($data->vpadding)){
			    $this->padding->top =		$data->vpadding;
			    $this->padding->bottom =		$data->vpadding;
		    }

		    if (isset ( $data->trigger ))		$this->trigger = $data->trigger;		
		    if (isset ( $data->position ))		$this->position = $data->position;
		    if (isset ( $data->align ))		$this->align = $data->align;
		    if (isset ( $data->valign ))		$this->valign = $data->valign;

		    if (isset ( $data->sidewidth))		$this->sidewidth->bind ( $data->sidewidth );
		    if (isset ( $data->border ))			$this->border->bind ( $data->border );
		    if (isset ( $data->background ))		$this->background->bind ( $data->background );

		    //display effects on display trigger
		    if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action !='none')){
			$effect = new PartDisplayEffect();
			$effect->bind($data->effects->display);
			$effect->event='display';
			$this->effects[] = $effect;
		    }
		    //display effects on hover trigger
		    if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action !='none')){
			$effect = new PartDisplayEffect();
			$effect->bind($data->effects->hover);
			$effect->event='hover';
			$this->effects[] = $effect;
		    }
		}
	}
	
	public function codeWizard($partObject){}
}
