<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

//require_once(NGEPATH_HELPERS . '/api/bootstrapbutton.php');
require_once(NGEPATH_HELPERS . '/api/bootstraplist.php');
require_once(NGEPATH_HELPERS . '/api/glyphs.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/padding.php');
require_once(NGEPATH_HELPERS . '/api/glyphs.php');
require_once(NGEPATH_HELPERS . '/api/itemwidth.php');
require_once(NGEPATH_HELPERS . '/api/backgroundlink.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartItems{
	
	/**
	 * @var String $style
	 */
	public $style;
	
	/**
	 * @var String $class
	 */
	public $class;
	
	/**
	 * @var PartBootstrapList $bootstrap
	 */
	public $bootstrap;

	/**
	* @var PartGlyph $glyph
	*/
	public $glyph;
	
	/**
	 * @var PartFont $font
	 */
	public $font;
	
	/**
	 * @var String $align
	 */
	public $align;

	/**
	 * @var PartPadding $padding
	 */
	public $padding;

	/**
	 * @var String $spacing
	 */
	public $spacing;
	
	/**
	 * @var PartItemwidth $width
	 */
	public $width;
	
	/**
	 * @var PartBackground $background
	 */
	public $background;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;
	
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;

	
	function __construct($preset = null){

		$this->style = '';
		$this->class = 		'';
		//$this->bootstrap =	new PartBootstrapbutton();
		$this->bootstrap =	new PartBootstraplist();
		$this->glyph =			new PartGlyphs();				
		$this->glyph->size =			'14'; //default value for list items
		$this->font = 	   		new PartFont();
		$this->align = 'left';
		$this->width = 	new PartItemwidth();
		$this->padding = 	new PartPadding();
		$this->padding->vpadding = 		8; 
		$this->padding->hpadding = 		12; 
		$this->spacing = '0';
		$this->background =	new PartBackgroundlink();
		$this->border = 	new PartBorder();
		$this->shadow =	new PartShadow();

	}
	
	public function bind($data){

		if (isset($data->style))		$this->style = 			$data->style;
		if (isset($data->class))		$this->class = 			$data->class;
		if (isset($data->bootstrap))		$this->bootstrap->bind ( $data->bootstrap );

		if (isset($data->glyph))		$this->glyph->bind($data->glyph);		
		if(isset($data->font))		$this->font->bind($data->font);
		
		if (isset($data->align))		$this->align = 			$data->align;
		if (isset ( $data->width ))
			$this->width->bind ( $data->width );
		if(isset($data->hpadding)){
		    $this->padding->left = $data->hpadding;
		    $this->padding->right = $data->hpadding;
		}
		if(isset($data->vpadding)){
		    $this->padding->top = $data->vpadding;
		    $this->padding->bottom = $data->vpadding;
		}
		
		if (isset ( $data->spacing ))		$this->spacing =		$data->spacing;
		if (isset ( $data->border ))		$this->border->bind ( $data->border );
		if (isset ( $data->background ))		$this->background->bind ( $data->background );
		if (isset ( $data->shadow ))		$this->shadow->bind ( $data->shadow );		

	}
	
	public function codeWizard($partObject){}
}
