<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Size class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class ItemDisplay{
	/**
	 * @var String $display
	 */
	public $mode;
	/**
	 * @var String $align
	 */
	public $align;
	/**
	 * @var PartSizeWidthObject $width
	 */
	public $width;
	/**
	 * @var PartSizeWidthObject $max_width
	 */
	//public $max_width;
	
	/**
	 * @var PartSizeHeightObject $height
	 */
	public $hpadding;
	/**
	 * @var PartSizeHeightObject $height
	 */
	public $vpadding;
	
	/**
	 * @var string $hmargin
	 */
	public $hmargin;
	
	/**
	 * @var sring $vmargin
	 */
	public $vmargin;
	
	
	/**
	 * @var PartMargin $margin
	 */
	//public $margin;
	
	function __construct(){
	    $this->mode 	=	'default';
	    $this->align 	= 	'center';
	    $this->width 	=	940;
	    //$this->max_width 	=	1224;
	    $this->hpadding 	=	20;
	    $this->vpadding 	=	20;
	    $this->hmargin 	=	0;
	    $this->vmargin 	=	0;
//        $this->margin 	= 	new PartMargin();
	}
	
	public function bind($data){
		if (isset($data->mode))	$this->mode	 	= 	$data->mode;			
		if (isset($data->align))	$this->align	 	= 	$data->align;
		if (isset($data->width))	$this->width	 	= 	is_numeric($data->width) ? $data->width."px" : $data->width;
	//	if (isset($data->max_width))	$this->max_width	 	= 	is_numeric($data->max_width) ? $data->max_width."px" : $data->max_width;
		if (isset($data->hpadding))	$this->hpadding	 	= 	is_numeric($data->hpadding) ? $data->hpadding."px" : $data->hpadding;
		if (isset($data->vpadding))	$this->vpadding	 	= 	is_numeric($data->vpadding) ? $data->vpadding."px" : $data->vpadding;
		if (isset($data->hmargin))	$this->hmargin	 	= 	is_numeric($data->hmargin) ? $data->hmargin."px" : $data->hmargin;
		if (isset($data->vmargin))	$this->vmargin	 	= 	is_numeric($data->vmargin) ? $data->vmargin."px" : $data->vmargin;
	}
		
}
