<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Size class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class ItemBodyDisplay{
	/**
	 * @var String $display
	 */
	public $mode;
	/**
	 * @var PartSizeHeightObject $height
	 */
	public $hpadding;
	/**
	 * @var PartSizeHeightObject $height
	 */
	public $vpadding;
	
	/**
	 * @var PartMargin $margin
	 */
	//public $margin;
	
	function __construct(){
	    $this->mode 	=	'default';
	    $this->hpadding 	=	20;
	    $this->vpadding 	=	20;
//        $this->margin 	= 	new PartMargin();
	}
	
	public function bind($data, $dataVersion=''){
	    
		if (isset($data->mode))	$this->mode	 	= 	$data->mode;			
		if (isset($data->hpadding))	$this->hpadding	 	= 	is_numeric($data->hpadding) ? $data->hpadding."px" : $data->hpadding;
		if (isset($data->vpadding))	$this->vpadding	 	= 	is_numeric($data->vpadding) ? $data->vpadding."px" : $data->vpadding;
	}
		
}
