<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item/div.php');
require_once(NGEPATH_HELPERS .'/api/item/page/body/display.php');
require_once(NGEPATH_HELPERS .'/api/item/tag.php');
require_once(NGEPATH_HELPERS . '/api/display/scrollbar.php');

/**
 * Panel class
 * @package 	Content
 * @subpackage  Panels/Panel
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgeItemPageBody extends NgeDiv {

	/**   
	 * @var ItemTag $h1
	 */
	public $h1;
	
	/**   
	 * @var ItemTag $h1
	 */
	public $h2;
	
	/**   
	 * @var ItemTag $h1
	 */
	public $h3;
	
	/**   
	 * @var ItemTag $h1
	 */
	public $h4;
	
	/**   
	 * @var ItemTag $h1
	 */
	public $h5;
	
	/**   
	 * @var ItemTag $h1
	 */
	public $h6;
	
    
	/**   
	 * @var ItemDisplay $display
	 */
	public $display;
	
	/**   
	 *	Scrollbar settings 
	 *	@var PartScrollbar $scrollbar
	*/
	public $scrollbar;
	
	
	

	function __construct(){
		parent::__construct();

		$this->h1 = new NgeItemTag();	
		$this->h2 = new NgeItemTag();	
		$this->h3 = new NgeItemTag();	
		$this->h4 = new NgeItemTag();	
		$this->h5 = new NgeItemTag();	
		$this->h6 = new NgeItemTag();	
		$this->name = 'page.body';
		$this->display = new ItemBodyDisplay();
		$this->scrollbar = 	new PartScrollbar();
				
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$this->display->bind($params->get('display'));
		$this->scrollbar->bind($params->get('scrollbar'));
		$this->h1->bind($params->get('h1'));
		$this->h2->bind($params->get('h2'));
		$this->h3->bind($params->get('h3'));
		$this->h4->bind($params->get('h4'));
		$this->h5->bind($params->get('h5'));
		$this->h6->bind($params->get('h6'));		
	}

}