<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Item class
 * for visual elements other than parts.
 * @package     CORE
 * @version		1.0.0
 * @since       1.0.0
 * 
 */
 
require_once NGEPATH_HELPERS . '/ngecontenthelper.php'; // used in part's layouts
require_once(NGEPATH_HELPERS . '/api/rendering.php');
require_once(NGEPATH_HELPERS . '/api/display.php');
require_once(NGEPATH_HELPERS . '/api/margin.php');
require_once(NGEPATH_HELPERS . '/api/access.php');
require_once(NGEPATH_HELPERS . '/api/publish.php');
require_once(NGEPATH_HELPERS . '/api/renderer.php');
require_once(NGEPATH_HELPERS . '/api/size.php');

abstract class NgeVisualItem{
	
	/**   
	 *	Name of the item
	 *	@var String $name   
	*/
	public $name;
	/**   
	 *	Id of the part
	 *	@var Integer $name   
	*/
	public $id;

	
	public function __construct(){
		$this->id = 		rand();
	}

	//Load existing part
	public function loadItem($itemObject){

		if($itemObject->id != ''){
			$this->id = $itemObject->id;
		}else{
			$this->id = rand();
		}
		if($itemObject->selector != '')
		    	$this->selector = $itemObject->selector;
		$partParamsRegistry = new JRegistry;
		$partParamsRegistry->loadString($itemObject->params);

		//Binding params in the current class		
		$this->bind($partParamsRegistry);
	}

	private function bindParams($paramString){
		$params = new JRegistry;
		$params->loadString($paramString);
		$this->bind($params);
	}

	/**
	 * bind data from Object (JRegistry Object)
	 */
	protected function bind($params){
	}
	
	public function display(){
		echo $this->render();
	}

	public function render($subfile=''){
		//Rendering	    
		return NGE::layout('nge.items.'.$this->name . ($subfile != '' ? '_' . $subfile : ''), $this);
	}
		
}
