<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/itemsize.php');

/**
 * Item class
 * parent of all parts that have item display
 * See also NgePanel class
 * @since       2.1.0
 */
 
class NgeItem extends NgePart {

    	/**   
	 *	Size and display options
	 *	@var PartSize $size   
	*/
	public $size;

	function __construct(){
		parent::__construct();
		$this->size = 	new PartItemSize();
		//Default values		
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		$this->size->bind($params->get('size'), $params->get('ngeversion'));
	}

	public function codeWizard($partObject){}
}