<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/caption.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/animationeffect.php');
//require_once(NGEPATH_HELPERS . '/api/hovereffect.php');
require_once(NGEPATH_HELPERS . '/api/legend.php');
require_once(NGEPATH_HELPERS . '/api/tooltip.php');
require_once(NGEPATH_HELPERS . '/api/popover.php');
require_once(NGEPATH_HELPERS . '/api/part/images/image/imageshape.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class NgePartImagesImageProperties extends NgePart{
	
	/**   
	 * @var parImageShape $shape
	 */
	public $shape;

	/**   
	 * @var string $style
	 */
	public $style;
	
	/**   
	 * @var parLink $link
	 */
	public $link;

	/**   
	 * @var parEffect $effect
	 */
	public $effect;
	
		/**   
	 * @var PartTooltip $tooltip   
	 */
	public $tooltip;
	
	/**   
	 * @var PartPopover $popover   
	 */
	public $popover;


	function __construct(){
		parent::__construct();

		$this->shape = 		new PartImageShape();		
		$this->style =		'default';
		$this->link = 		new PartLink();		
		$this->effect =		new PartAnimationEffect();		
		
		$this->tooltip = 		new PartTooltip();
		$this->popover = 		new PartPopover();
	
		
		
	}

	//Bind params from json stored parameters
	public function bind($data){
		//Common part properties
		if (isset($data->shape))	$this->shape->bind($data->shape);
		if (isset($data->style))	$this->style = $data->style;
		if (isset($data->link))		$this->link = $data->link;
		if (isset($data->effect))	$this->effect = $data->effect;
		
		if (isset($data->tooltip))	$this->tooltip = $data->tooltip;
		if (isset($data->popover))	$this->popover = $data->popover;
		
	}

	public function codeWizard($partObject){}
}