<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/tag.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');
require_once(NGEPATH_HELPERS . '/api/strikeout.php');
require_once(NGEPATH_HELPERS . '/api/padding.php');
require_once(NGEPATH_HELPERS . '/api/sizewidthobject.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartHeader extends PartTag{
	
	/**
	* @var String $style
	 *  pattern, custom
	 */
	public $style;

    
	/**
	 * @var PartFont $font
	 */
	public $font;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;

	/**
	 * @var PartBackground $background
	 */
	public $background;
		
	/**
	 * @var String $label
	 */
	public $label;
	
	/**
	 * @var String $glyphname
	 */
//	public $glyphname;
	
	/**
	 * @var String $display
	 */
	public $display;
	
	/**
	 * @var String $position
	 */
	public $position;

	/**
	 * @var PartSizeWidthObject $sidewidth
	 */
	public $sidewidth;

	/**
	 * @var String $orientation
	 */
	public $orientation;

	/**
	 * @var String $align
	 */
	public $align;
	
	/**
	 * @var String $align
	 */
	public $valign;
	
	/**
	 * @var PartPadding $padding
	 */
	public $padding;
	/**
	 * @var String $margin
	 */
	public $margin;
	/**
	 * @var PartGlyph $glyph
	 */
	public $glyph;

	/**
	 * @var PartStrikeout $strikeout
	 */
	public $strikeout;

	/**
	 * @var array $effects
	 */
	public $effects;
	
	
	function __construct($preset = null){

	    	parent::__construct();
		
		$this->style = 'custom';
		
		$this->tag = 'h1';
		$this->label = 		'';
//		$this->glyphname = 	'';
		$this->glyph = 		new PartGlyph();
		$this->strikeout = 		new PartStrikeout();
		$this->display = 	'1';
		$this->position = 		'top';
		$this->orientation = 		'horizontal';
		$this->sidewidth =		new PartSizeWidthObject('bootstrap');
		$this->align = 		'left';
		$this->valign = 		'top';
		$this->padding = 		new PartPadding();
		$this->padding->top = 8;
		$this->padding->bottom = 8;
		$this->padding->left = 12;
		$this->padding->right = 12;		
		$this->margin = 	'0';
		$this->font = 	   	new PartFont();
		$this->border = 	new PartBorder();
		$this->background =	new PartBackground();
		$this->effects		= array();
	}
	
	public function bind($data){
		//Content
		if (isset ( $data->label ))
			$this->label = $data->label;
//		if (isset ( $data->glyphname ))
//			$this->glyphname = $data->glyphname;
		//Options
		if (isset($data->style))    $this->style = $data->style;

		if (($this->style == 'pattern') && (isset($data->pattern))){	
		    $patternId = $data->pattern;
		    if ($data->pattern != '')
			$data = $this->loadPattern($data->pattern);		    
		}
		
		if (($this->style == 'custom') || (($this->style == 'pattern') && ($patternId != ''))){

		    if (isset ( $data->display ))		$this->display = $data->display;
		    if (isset ( $data->position ))		$this->position = $data->position;

		    if (isset ( $data->orientation ))		$this->orientation = $data->orientation;
		    if (isset ( $data->sidewidth))		$this->sidewidth->bind ( $data->sidewidth );

		    if (isset ( $data->align ))			$this->align = $data->align;
		    if (isset ( $data->valign ))			$this->valign = $data->valign;
		    if(isset($data->hpadding)){
			$this->padding->left = $data->hpadding;
			$this->padding->right = $data->hpadding;
		    }
		    if(isset($data->vpadding)){
			$this->padding->top = $data->vpadding;
			$this->padding->bottom = $data->vpadding;
		    }

		    if (isset ( $data->margin ))		$this->margin = $data->margin;		
		    if (isset ( $data->tag ))		$this->tag = $data->tag;

		    if (isset ( $data->font ))		$this->font->bind ( $data->font );
		    if (isset ( $data->glyph ))		$this->glyph->bind ( $data->glyph );
		    if (isset ( $data->strikeout ))		$this->strikeout->bind ( $data->strikeout );
		    if (isset ( $data->border ))		$this->border->bind ( $data->border );
		    if (isset ( $data->background ))		$this->background->bind ( $data->background );

		    //display effects on display trigger
		    if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action !='none')){
			$effect = new PartDisplayEffect();
			$effect->bind($data->effects->display);
			$effect->event='display';
			$this->effects[] = $effect;
		    }
		    //display effects on hover trigger
		    if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action !='none')){
			$effect = new PartDisplayEffect();
			$effect->bind($data->effects->hover);
			$effect->event='hover';
			$this->effects[] = $effect;
		    }		
		}
		else //bind only content
		    if (isset ( $data->glyph) && isset ($data->glyph->name))	$this->glyph->name = $data->glyph->name;
	}
	
	public function codeWizard($partObject){}
}
