<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/glyphbackground.php');

/**
 * Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartGlyphs{
	
	/** 
	 *	@var String $position Glyph position from the text can be "left" or "right"
	 */
	public $position;
	
	/**
	 *	@var String $size Glyph size
	 */
	public $size;
	
	/**
	 *	@var String $color Glyph color
	 */
	public $color;
	
	/**
	* @var String $trigger
	*/
	public $trigger;

	/**
	* @var PartGlyphBackground $background
	*/
	public $background;

	
	function __construct(){
		$this->position =		'left';
		$this->size = 		'30';
		$this->color = 		'';				
		$this->color_hover = 	'';				
		$this->color_active = 	'';	
		$this->trigger =		'always';	
		$this->background =		new PartGlyphBackground();
	}
	
	public function bind($data){

		if (isset($data->position)) 	$this->position =		$data->position;
		if (isset($data->size)) 	$this->size = 		$data->size;
		if (isset($data->color)) 	$this->color = 		$data->color;
		if (isset($data->color_hover)) 	$this->color_hover = 	$data->color_hover;
		if (isset($data->color_active)) 	$this->color_active = 	$data->color_active;
		if (isset($data->trigger))	$this->trigger 	= 	$data->trigger; 
		if (isset($data->background))	$this->background->bind($data->background); 
	}
	
	public function codeWizard($partObject){}
}
