<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartGlyphBackground{

	/** 
	 *	@var String $shape
	 */
	public $shape;

	/**
	 *	@var String $size Glyph size
	 */
	public $padding;
	/**
	 *	@var String $color Glyph color
	 */
	public $color;
		
	
	function __construct(){
		$this->shape = 	'none';
		$this->padding = '24';
		$this->color = 	'#ffffff';		
	}
	
	public function bind($data){

		if (isset($data->shape)) 		$this->shape = 	$data->shape;
		if (isset($data->padding)) 			$this->padding = 		$data->padding;
		if (isset($data->color)) 			$this->color = 		$data->color;
	}
	
	public function codeWizard($partObject){}
}
