<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/glyphbackground.php');
require_once(NGEPATH_HELPERS . '/api/effects/displayeffect.php');

/**
 * Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartGlyph{
	/** 
	 *	@var String $position Glyph position from the text can be "left" or "right"
	 */
	public $position;
	/**
	 *	@var String $name Glyph name
	 *	@example "icomoon-home", "icomoon-headphones", "icomoon-twitter2"
	 */
	public $name;
	/**
	 *	@var String $size Glyph size
	 */
	public $size;
	/**
	 *	@var String $color Glyph color
	 */
	public $color;
	
	/**
	 *	@var PartGlyphBackground $background
	 */
	public $backround;
	
	/**
	 * @var array $effects
	 */
	public $effects;
	
	
	/**
     * @var String $trigger
     */
    public $trigger;
	
	function __construct(){
		
		$this->position = 	'left';
		$this->name = 		'';
		$this->size = 		'30';
		$this->color = 		'#666666';	
		$this->trigger =		'always';
		$this->background =	new PartGlyphBackground();
		$this->effects		= array();
	}
	
	public function bind($data){
		if (isset($data->position)) 		$this->position = 	$data->position;
		if (isset($data->name)) 		$this->name = 		$data->name;
		if (isset($data->size)) 		$this->size = 		$data->size;
		if (isset($data->color)) 		$this->color = 		$data->color;
		if (isset($data->color_hover)) 	$this->color_hover = $data->color_hover;
		if(isset($data->trigger))		$this->trigger 	= 	$data->trigger; 
		if (isset($data->background))	$this->background->bind($data->background);
		
		//display effects on display trigger
		if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->display);
		    $effect->event='display';
		    $this->effects[] = $effect;
		}
		//display effects on hover trigger
		if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->hover);
		    $effect->event='hover';
		    $this->effects[] = $effect;
		}
		
	}
	
	public function codeWizard($partObject){}
}
