<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

/**
 * Font class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartFont{
	private $preset;
	/** 
	 *	@var String $style Can be "custom", "css", "h1", "h2", "h3" or "h4"
	 */
	public $style;
	/**
	 *	@var String $class Can take all css class value available, for example "btn" from bootstrap.
	 *	@uses PartFont::$style Works only with $style equal "css"
	 */
	public $class;
	/**
	 *	@var String $name Font family name if available for the current browser
	 *	@example "Arial", "Comic Sans MS", "Open Sans"
	 */
	public $css;
	/**
	 *	@var String $css 
	 */
	public $name;
	/**
	 *	@var String $color Font color
	 */
	public $color;
	/**
	 * @var String $color_hover
	 */
	public $color_hover;
	/**
	 * @var String $color_active
	 */
	public $color_active;
	/**
	 *	@var String $color_link Font color
	 */
	public $color_link;
	/**
	 * @var String $color_link_hover
	 */
	public $color_link_hover;
	/**
	 *	@var String $decoration Font decoration
	 */
	public $decoration;
	
	/**
	 *	@var String $size Font size
	 */	
	public $size;
	/**
	 *	@var String $letter_spacing Space between each letter of the font
	 */
	public $letter_spacing;
	
	/**
	 *	@var String $weight Weight of the font
	 *	@example "100", "200", "bold"
	 */
	public $weight;
	/**
	 *	@var String $italic 1 if the font is italic else 0
	 */
	public $italic;
	
	/**
	 *	@var String $case
	 */
	public $case;
	
	function __construct(){
		$this->style = 			'default';
		$this->class = 			'';
		$this->css = 			'';		
		$this->name = 			'Default';
		$this->color = 			'#666666';
		$this->color_hover = 		'';
		$this->color_active = 		'';
		$this->color_link = 			'';
		$this->color_link_hover = 		'';
		$this->decoration = 			'';
		$this->size = 			'30';
		$this->letter_spacing =		'0';
		$this->weight = 		'normal';
		$this->italic = 		'0';
		$this->case = 		'none';
		
		switch ($this->preset){
			case 'button' :
				$this->size = 12;
				break;
		}					
	}
	
	public function bind($data){
		if (isset($data->style))	$this->style = 			$data->style;
		if (isset($data->class))	$this->class = 			$data->class;
		if (isset($data->css))		$this->css = 			$data->css;
		if (isset($data->name))	$this->name = 			$data->name;
		if (isset($data->color))	$this->color = 			$data->color;
		if (isset($data->color_hover))	$this->color_hover = 			$data->color_hover;
		if (isset($data->color_active))	$this->color_active = 			$data->color_active;
		if (isset($data->color_link))	$this->color_link = 			$data->color_link;
		if (isset($data->color_link_hover))	$this->color_link_hover = 			$data->color_link_hover;
		if (isset($data->decoration))	$this->decoration = 			$data->decoration;
		if (isset($data->size))		$this->size = 			$data->size;
		if (isset($data->letter_spacing))	$this->letter_spacing =		$data->letter_spacing;
		if (isset($data->weight))	$this->weight =			$data->weight;
		//If custom font (100 to 900), replacing value
		if ($this->weight == 'custom'){
		    if (isset($data->custom_weight))
			$this->weight = $data->custom_weight;
		    else
			$this->weight = 'normal';
		}
		    
		if (isset($data->italic))   	$this->italic = 		$data->italic;
		if (isset($data->case))		$this->case = 		$data->case;
	}
	
	public function codeWizard($partObject){
	
		$html = array();
		$params = new JRegistry;
		$params->loadString($partObject->params);
		
		//Font
		if ($params->get('font')->style == 'custom'){
			$html[] = '';
			$html[] = '$'.'part->style = "custom";';
			$html = array_merge($html , $this->codeCompare('', $params->get('font'), 'part->font->', array('name', 'size', 'letter_spacing', 'color', 'weight', 'italic')));
		}
		else
		if (($params->get('font')->style == 'class') && ($params->get('font')->class != $this->class)){
			$html[] = '';
			$html[] = '$'.'part->font->style = "class";';
			$html[] = '$'.'part->font->class = "'.$params->get('font')->class.'";';
		}
	
		$html[] = '';
	
		return $html;
	}
}
