<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Animate class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartEffect{
	/**
	 * @var String $name
	 */
	public $name;
	
	/**
	 * @var String $type
	 */
	public $type;

	/**
	 * @var String $event
	 * Is the main event that launch the effect
	 */
	public $event;
	
	/**
	 * @var String $trigger
	 *  Is a sub trigger that can control the effect lauch (for example display at loading or at viewportdisplay)
	 */
	public $trigger;

	/**
	 * @var int $strength
	 */
	public $strength;
	
	/**
	 * @var String $delay
	 */
	public $delay;
	/**
	 * @var String $duration
	 */
	public $duration;
	/**
	 * @var String $cycling
	 */
	public $cycling;
	/**
	 * @var String $iteration
	 */
	public $iteration;
	
	function __construct($type='', $name='', $event=''){
		$this->type = 	$type != '' ? $type : '';
		$this->name = 	$name != '' ? $name : '';
		$this->event = 	$event != '' ? $event : 'display'; //display - hover - click - scroll
		$this->trigger = 	'';
		$this->delay = 	'0'; //seconds
		$this->strength = 	'2'; //1 to 10
		$this->duration = 	'1'; //seconds
		/*$this->cycling = 	'none';
		$this->iteration = 	'1';*/
	}
	
	public function bind($data){
		if(isset($data->type))		$this->type = 	$data->type;
		if(isset($data->name))		$this->name = 	$data->name;
		if(isset($data->trigger))		$this->trigger = 	$data->trigger;
		if(isset($data->strength))		$this->strength = 	$data->strength;
		if(isset($data->delay))		$this->delay = 	$data->delay;
		if(isset($data->duration))		$this->duration = 	$data->duration;
/*		if(isset($data->cycling))		$this->cycling = 	$data->cycling;
		if(isset($data->iteration))		$this->iteration = 	$data->iteration;*/
	}
	
	public function codeWizard($partObject){}
}
