<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/effects/effect.php');

/**
 * Animate class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDisplayEffect extends PartEffect{

	/**
	 * @var String $origin
	 */
	public $origin;

	/**
	 * @var String $direction
	 */
	public $direction;

	/**
	 * @var String $pivot
	 */
	public $pivot;
	
	
	/**
	 * @var String $strength
	 */
//	public $strength;
	
	/**
	 * @var String $speed
	 */
//	public $speed;
	
	function __construct($name='', $event=''){
	    
		parent::__construct($name, $event);
		$this->type = 	'display';
		$this->origin = 	'none';
		$this->direction = 	'none';
		//$this->strength = 'default';
		//$this->speed = 'fast';
	}
	
	public function bind($data){
	    
		parent::bind($data);	    

		if(isset($data->direction))		$this->direction = 	$data->direction;
		if (isset($data->action)){
		    $this->action = 	$data->action;

		    switch ($data->action){
			case 'show' :
			    if (isset($data->show)){
				if (isset($data->show->name)){
				    $this->name = $data->show->name;
				    $name = $this->name;
				    if (isset($data->show->$name->origin))
					$this->origin = $data->show->$name->origin;
				    if (isset($data->show->$name->direction))
					$this->direction = $data->show->$name->direction;
				    if (isset($data->show->$name->pivot))
					$this->pivot = $data->show->$name->pivot;				    
				}
			    }
			    break;
			case 'animate' :			
			    if (isset($data->animate) && (isset($data->animate->name))){
				    $this->name = $data->animate->name;
				    
				    switch ($data->animate->name){
					case 'size' : 
					    $this->name = $data->animate->size->name;
					    break;
					case 'move' : 
					    if (isset($data->animate->move->origin))
						$this->origin = $data->animate->move->origin;
					    if (isset($data->animate->move->direction))
						$this->direction = $data->animate->move->direction;					    
					    break;
				    }
			    }
			    break;
			case 'colors' :
			    if (isset($data->colors) && (isset($data->colors->name))){
				    $this->name = $data->colors->name;
				    $name = $this->name;				    
				    if (isset($data->colors->$name->direction))
					$this->direction = $data->colors->$name->direction;
			    }
			    break;
			case 'hide' :
			    if (isset($data->hide)){
				if (isset($data->hide->name)){
				    $this->name = $data->hide->name;
				    $name = $data->hide->name;
				    if (isset($data->hide->$name->direction))
					$this->direction = $data->hide->$name->direction;
				}
			    }
			    break;			
		    }
		}

	}
	
	public function codeWizard($partObject){}
}