<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/effects/effect.php');

/**
 * Animate class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartBackgroundEffect extends PartEffect{

	/**
	 * @var String $color
	 */
	public $color;
	
	/**
	 * @var String $color2
	 */
	public $color2;

	/**
	 * @var String $opacity
	 */
	public $opacity;
	
	/**
	 * @var String $image
	 */
	public $image;
	
	
	function __construct($name='', $trigger=''){
	    
		parent::__construct('background', $name, $trigger);
		$this->color = '';
		$this->color2 = '';
		$this->opacity = 100;
		$this->image = '';
		//$this->type = 	'background';
	}
	
	public function bind($data){
	    
		parent::bind($data);

		if(isset($data->color))		$this->color = 	$data->color;
		if(isset($data->color2))		$this->color2 = 	$data->color2;
		if(isset($data->opacity))		$this->opacity = 	$data->opacity;
		if(isset($data->image))		$this->image = 	$data->image;
		if(isset($data->direction))		$this->direction = 	$data->direction;
	}
	
	public function codeWizard($partObject){}
}
