<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Animate class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartEffect{
	/**
	 * @var String $style
	 */
	public $style;
	
	/**
	 * @var String $trigger
	 */
	public $trigger;
	
	/**
	 * @var String $delay
	 */
	public $delay;
	/**
	 * @var String $duration
	 */
	public $duration;
	/**
	 * @var String $cycling
	 */
	public $cycling;
	/**
	 * @var String $iteration
	 */
	public $iteration;
	
	function __construct(){
		$this->style = 		'';
		$this->trigger = 	'none';
		$this->delay = 		'0';
		$this->duration = 	'2';
		$this->cycling = 	'none';
		$this->iteration = 	'1';
	}
	
	public function bind($data){
		if(isset($data->style)){
			$this->style = 		$data->style;
			switch($data->style){
				case '' :
					if (isset($data->animate))
						$this->style = $data->style.$data->animate;
					break;
				case 'bounceIn' :
					$this->style = $data->style.$data->bounce;
					break;
				case 'color' :
					$this->style = $data->style.$data->color.$data->color_strength;
					break;
				case 'animate' :
					$this->style = $data->style.$data->animate;
					break;
				case 'zoom' :
					$this->style = $data->style.$data->zoom.$data->zoom_direction;
					break;
				case 'fadeIn' :
					$this->style = $data->style.$data->fadein.$data->fadein_strength;
					break;
				case 'flip' :
					$this->style = $data->style.$data->flip;
					break;
				case 'lightSpeed' :
					$this->style = $data->style.$data->lightspeed;
					break;
				case 'slide' :
					$this->style = $data->style.$data->slide;
					if($data->slide=='In')
						$this->style .= $data->slide_in;
					if($data->slide=='Out')
						$this->style .= $data->slide_out;
					break;
				case 'rotateIn' :
					$this->style = $data->style.$data->rotate;
					break;
			}
		}
		if(isset($data->trigger))		$this->trigger = 	$data->trigger;
		if(isset($data->delay))		$this->delay = 		$data->delay;
		if(isset($data->duration))		$this->duration = 	$data->duration;
		if(isset($data->cycling))		$this->cycling = 	$data->cycling;
		if(isset($data->iteration))		$this->iteration = 	$data->iteration;
	}
	
	public function codeWizard($partObject){}
}
