<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/bootstrapbutton.php');
//require_once(NGEPATH_HELPERS . '/api/padding.php');
require_once(NGEPATH_HELPERS . '/api/listitems.php');
require_once(NGEPATH_HELPERS . '/api/links.php');
require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/header.php');
require_once(NGEPATH_HELPERS . '/api/legend.php');
require_once(NGEPATH_HELPERS . '/api/part/navigation/list/listnavigationpaging.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDropdown extends PartBody{
	
	/**
	 * @var String $position
	 */
	public $position;

	/**
	 * @var PartItemwidth $width
	 */
	public $width;

	
	/**
	 * @var PartListRendering $rendering
	 */
	public $rendering;

			
	/**
	 * @var PartPadding $padding
	 */
	//public $padding;

	/**
	 * @var PartHeader $header
	 */
	public $header;
	
	/**
	 * @var PartListItems $items
	 */
	public $items;
	
		/**
	 * @var PartLegend $legend
	 */
	public $legend;
	
	
	function __construct($preset = null){

		parent::__construct();
		$this->shadow->display = 'always';			
		$this->shadow->style = "default";
		
		$this->position = '';
		$this->width = 	new PartItemwidth();		
		/*$this->padding = 	new PartPadding();
		$this->padding->vpadding = 		8; 
		$this->padding->hpadding = 		12; */
		$this->header = 			new PartHeader();
		$this->items =			new PartListItems();
		//Default values
		$this->items->padding->left = '20';
		$this->items->padding->right = '20';
		$this->items->padding->top = '20';
		$this->items->padding->bottom = '20';
		
		$this->legend =			new PartLegend();
		//$this->rendering =			new PartListRendering();
		$this->rendering =			new PartListNavigationPaging();
				
		$this->orientation = 'vertical';
		$this->align_horizontal = '';
		$this->align_vertical = '';
//		$this->width = null;

	}
	
	public function bind($data){
		
		parent::bind($data);
		
		if (isset($data->position))	$this->position = 			$data->position;
		if (isset($data->class))	$this->class = 			$data->class;
		
		if (isset ( $data->width ))	$this->width->bind ( $data->width );
		
		/*
		if(isset($data->hpadding)){
		    $this->padding->left = $data->hpadding;
		    $this->padding->right = $data->hpadding;
		}
		if(isset($data->vpadding)){
		    $this->padding->top = $data->vpadding;
		    $this->padding->bottom = $data->vpadding;
		}
		*/
		if (isset ( $data->rendering ))			$this->rendering->bind ( $data->rendering );
		
		if (isset($data->header))			$this->header->bind($data->header);
		if (isset($data->items))			$this->items->bind($data->items);
		if (isset($data->legend))			$this->legend->bind($data->legend);
		

		if (isset ( $data->orientation )) $this->orientation = $data->orientation;
		if (isset ( $data->align_horizontal )) $this->align_horizontal = $data->align_horizontal;
		if (isset ( $data->align_horizontal )) $this->align_vertical = $data->align_vertical;
		if (isset ( $data->align_horizontal )) $this->width = $data->width;

	}
	
	public function codeWizard($partObject){}
}
