<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/partproperty.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/display/scrollbarborder.php');


/**
 * Panel class
 * @package 	Content
 * @subpackage  Panels/Panel
 * @version 	2.0.0
 * @since       2.0.0
 */
 
class PartScrollbar extends NgePartProperty{

	/**
	 * @var style
	 */
	public $style;
	
	/**
	 * @var trigger
	 */
	public $trigger;
	
	/**
	 * @var width
	 */
	public $width;

	/**
	 * @var radius
	 */
	public $radius;
	
	/**
	 * @var String $color
	 */
	public $color;
	
	/**
	 * @var PartScrollbarBackground $background
	 */
	public $background;


	/**   
	 * @var PartScrollbarBorder $border
	 */
	public $border;
		

	function __construct(){

		//Default values		
		$this->width = 	"5";
		$this->radius = 	"5";
		$this->style = 	'default';
		$this->color = 	'#424242';
		$this->trigger = 	'always';
		
// 		$this->padding->default = 	'10';
		$this->border = 	new PartScrollbarBorder();
		$this->background = 	new PartBackground();
	}

	//Bind params from JRegistry data object
	public function bind($data){
	    
	    
		if (isset($data->style))		$this->style = $data->style;

		if (($this->style == 'pattern') && (isset($data->pattern))){	
		    $patternId = $data->pattern;
		    if ($data->pattern != '')
			$data = $this->loadPattern($data->pattern);		    
		}

		if (($this->style == 'custom') || (($this->style == 'pattern') && ($patternId != ''))){						
		    if (isset($data->trigger))		$this->trigger = $data->trigger;
		    if (isset($data->width))		$this->width = $data->width;
		    if (isset($data->radius))		$this->radius = $data->radius;
		    if (isset($data->color))		$this->color = $data->color;
		    if (isset($data->border))		$this->border->bind($data->border);
		    if (isset($data->background))	$this->background->bind($data->background);
		}
	}

	public function codeWizard($partObject){}
}