<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/restriction.php');

/**
 * Display class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDisplay{
	
	public $class;
	public $phone;
	public $tablet;
	public $desktop;
	public $printer;
	
	public $names; //Available restrictions
		
	
	function __construct(){
		$this->class = 		'';
		$this->phone =		'1';
		$this->tablet =		'1';
		$this->desktop =	'1';
		$this->printer =	'1';
		
		$this->restrictions = array();
		//$this->genericfields = array('user', 'usergroup', 'viewlevel',
		    $this->genericfields = array('user', 'userlevel',
		    'homepage', 'menuitem', 'category', 'tag', 'article', 'component',
		    'dayofweek',
		    'language');
		
	}
	
	public function bind($data){
		if (isset($data->class))	$this->class = 	$data->class;
		if (isset($data->phone))	$this->phone =	$data->phone;
		if (isset($data->tablet))	$this->tablet =	$data->tablet;
		if (isset($data->desktop))	$this->desktop =	$data->desktop;
		if (isset($data->printer))	$this->printer =	$data->printer;
	
		//generic input fields
		foreach ($this->genericfields as $name){
		    if (isset($data->$name) && $data->$name->filter != "all" && $data->$name->filter != "always"){
			$restriction = new PartRestriction($name);
			$restriction->bind($data->$name);
			$this->restrictions[] = $restriction;
		    }		
		}
		//Specific input fields
		if (isset($data->date) && $data->date->filter != "all"){
		    $restriction = new PartRestriction('date');
		    $restriction->filter = $data->date->filter;
		    $restriction->values[] = $data->date->from;
		    $restriction->values[] = $data->date->to;
		    $this->restrictions[] = $restriction;
		}
		if (isset($data->time) && $data->time->filter != "all"){
		    $restriction = new PartRestriction('time');
		    $restriction->filter = $data->time->filter;
		    $restriction->values[] = $data->time->from;
		    $restriction->values[] = $data->time->to;
		    $this->restrictions[] = $restriction;
		}		
		//Device New way 1.1.x
		if (isset($data->device) && ($data->device->phone != "1" || $data->device->tablet != "1" || $data->device->desktop != "1" || $data->device->printer != "1")){
		    $restriction = new PartRestriction('device');
		    $restriction->filter = 'only';
		    if ($data->device->phone == "1")	$restriction->values[] = 'phone';
		    if ($data->device->tablet == "1")	$restriction->values[] = 'tablet';
		    if ($data->device->desktop == "1")	$restriction->values[] = 'desktop';
		    if ($data->device->printer == "1")	$restriction->values[] = 'printer';
		    $this->restrictions[] = $restriction;
		}
		else //Device : Old compatibility 1.0. Warning, test after new compatibility to not use old sotred values
		if (isset($data->phone) || isset($data->tablet) || isset($data->desktop) || isset($data->printer)){
		    $restriction = new PartRestriction('device');
		    $restriction->filter = 'only';
		    if (isset($data->phone) && $data->phone == "1")		$restriction->values[] = 'phone';
		    if (isset($data->tablet) && $data->tablet == "1")		$restriction->values[] = 'tablet';
		    if (isset($data->desktop) && $data->desktop == "1")	$restriction->values[] = 'desktop';
		    if (isset($data->printer) && $data->printer == "1")		$restriction->values[] = 'printer';
		    $this->restrictions[] = $restriction;
		}
	}
	
	public function codeWizard($partObject){}
}
