<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartVideoPreviewContent {

	/**   
	 * @var String $mode auto/custom
	 */
	public $mode;
	
	/**   
	 * @var String $image
	 */
	public $image;
	
	function __construct(){
		$this->mode = 	'auto';
		$this->image = 	'';
	}
	
	public function bind($data){
		if (isset($data->mode))		$this->mode = 	$data->mode;
		if (isset($data->image))		$this->image = 	$data->image;
	}
}

class PartVideoContent {

	/**
	 * @var String $title
	 */
//	public $title;
	
	/**   
	 * @var String $source
	 */
	public $source;
	
	/**   
	 * @var String $reference
	 */
	public $reference;

	/**   
	 * @var String $preview
	 */
	public $preview;
	
	
	function __construct(){
		$this->source = 	'';
		$this->reference = 		'';
		$this->preview = new PartVideoPreviewContent();
	}
	
	public function bind($data){
		if (isset($data->source))		$this->source = 	$data->source;
		switch ($this->source) {
		    case 'file' :
			if (isset($data->file))		$this->reference = 	$data->file;
			break;
		    case 'youtube' :
			if (isset($data->youtube))	$this->reference = $data->youtube;
			break;
		    case 'vimeo' :
			if (isset($data->vimeo))	$this->reference = $data->vimeo;
			break;
		    case 'dailymotion' :
			if (isset($data->dailymotion))	$this->reference = $data->dailymotion;
			break;
		}
		if (isset($data->preview))		$this->preview->bind($data->preview);
	}
	
	public function codeWizard($partObject){}
}