<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Display class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartThumbnailSpacing{
	
	public $mode;
	public $vertical;
	public $horizontal;
	
	function __construct(){
		$this->mode =			'auto';
		$this->vertical = 		'20';
		$this->horizontal =		'20';
	}
	
	public function bind($data){
		if (isset($data->spacing->mode))		$this->mode = 		$data->spacing->mode;
		
		if (isset($data->width->mode)){
			if (($data->width->mode == 'fixed') && isset($data->spacing->horizontal_fixed))
				$this->horizontal =	is_numeric($data->spacing->horizontal_fixed)? $data->spacing->horizontal_fixed.'px' : $data->spacing->horizontal_fixed;
			else
				if (isset($data->spacing->horizontal_fluid))
				$this->horizontal =	is_numeric($data->spacing->horizontal_fluid)? $data->spacing->horizontal_fluid.'%' : $data->spacing->horizontal_fluid;
		}
		if (isset($data->spacing->vertical))	$this->vertical =	$data->spacing->vertical;
	}
	
	public function codeWizard($partObject){}
}
