<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnailsglyph.php');

/**
 * Thumbnails Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartThumbnailsHeader{

	/**
	 * @var PartFont $font
	 */
	public $font;
	/**
	 * @var PartBackground $background
	 */
	public $border;
	/**
	 * @var PartBackground $background
	 */
	public $background;
	/**
	 * @var String $display
	 */
	public $display;
	/**
	 * @var String $align
	 */
	public $align;
	
	/**
	 * @var String $valign
	 */
	public $valign;
	
	/**
	 * @var String $padding
	 */
	public $padding;
	/**
	 * @var PartGlyph $glyph
	 */
	public $glyph;
	
	function __construct($preset = null){		
		$this->display = 	'1';
		$this->align = 		'left';
		$this->valign = 		'top';
		$this->padding = 	'5';
		$this->font = 	   	new PartFont();
		$this->border =		new PartBorder();
		$this->background =		new PartBackground();
		$this->glyph = 		new PartThumbnailsGlyph();
	}
	
	public function bind($data){
		if (isset($data->display))		$this->display = 	$data->display;
		if (isset($data->align))		$this->align = 		$data->align;
		if (isset($data->valign))		$this->valign = 		$data->valign;
		if (isset($data->padding))		$this->padding = 	$data->padding;
		if (isset($data->font))		$this->font->bind($data->font);
		if (isset($data->border))		$this->border->bind($data->border);
		if (isset($data->background))		$this->background->bind($data->background);
		if (isset($data->glyph))		$this->glyph->bind($data->glyph);
	}
	
	public function codeWizard($partObject){}
}
