<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

/**
 * Thumbnails Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartThumbnailsGlyph{
	/** 
	 *	@var String $position Glyph position from the text can be "left" or "right"
	 */
	public $position;
	/**
	 *	@var String $size Glyph size
	 */
	public $size;
	/**
	 *	@var String $color Glyph color
	 */
	public $color;
	
	function __construct(){
		$this->position = 	'left';
		$this->size = 		'30';
		$this->color = 		'#666666';				
	}
	
	public function bind($data){
		$this->position = 	$data->position;
		$this->size = 		$data->size;
		$this->color = 		$data->color;
	}
	
	public function codeWizard($partObject){}
}
