<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnailcustomcontent.php');

/**
 * Thumbnails content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartThumbnailsContent extends PartMultiplecontent{
		
	
    	//Dynamic creation for the tables from a datasource
    /*
	protected function bindSource($params){
	    $contentParams = $params->get('content');

	    $sourceKeys = array_map('ucfirst', explode('.', $contentParams->source));
	    $contentClassName = 'Nge' . implode($sourceKeys) . 'Content';
	    if (file_exists(NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $contentParams->source) . '/content.php')){
		require_once NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $contentParams->source) . '/content.php';
		$items = $contentClassName::loadList($contentParams);

		//Filling tabs
		for ($i = 0;$i<count($items); $i++){
		    $header = $contentClassName::getLabel($items[$i], $contentParams);
		    $body = $contentClassName::getBody($items[$i], $contentParams);
		    //$caption = $contentClassName::getCaption($items[$i], $contentParams);
		    $caption='';
		    $this->add($header, $body, $caption);
		}
		$this->source ='html'; //Source has been prepared. It is now html
	    }

	}
    */
    
	protected function bindCustom($params){

	    //New compatibility
	    $content = $params->get('content');
	    if (isset($content)) {
		$count = $content->count;
		for ($i=0;$i<$count; $i++){
		    $customThumbnailContent = new PartThumbnailCustomContent();
		    $customThumbnailContent->bind($content->items[$i]);
		    //$customLinkItem->label='ooo';
		    $this->items[] = $customThumbnailContent;
		}
	    } else {	    
	    //Old compatibility V 1.0
	    $sources 	=	$params->get('sources');
	    if (isset($sources)) {
		$this->version = '1';
		$count = $params->get('count');

		//Creating default items
		for ($i=0;$i<$count; $i++){
			$this->items[] = new PartThumbnailcustomcontent();
		}
			
		/***** Get Params *****/
		//Body
		$sources		= $params->get('sources');
		$htmls 		= $params->get('htmls');
		$articles		= $params->get('articles');
		$modules		= $params->get('modules');
		$urls 		= $params->get('urls');
		$querys 		= $params->get('querys');
		$images 		= $params->get('images');
		$captions 		= $params->get('captions');
		$legends 		= $params->get('legends');

		//Hover panel
		/*$hover_sources 	= $params->get('hover_sources');
		$hover_htmls	= $params->get('hover_htmls');
		$hover_articles	= $params->get('hover_articles');
		$hover_modules 	= $params->get('hover_modules');
		$hover_urls 	= $params->get('hover_urls');
		$hover_querys 	= $params->get('hover_querys');*/

		//Caption
		$caption_htmls	= $params->get('caption_htmls');

		//Title
		$labels 			= $params->get('header_labels');
		$glyph_names 		= $params->get('header_glyph_names');

		//Link
		$link_types 	= $params->get('link_types');
		$link_menus 	= $params->get('link_menus');
		$link_articles 	= $params->get('link_articles');
		$link_images 	= $params->get('link_images');
		$link_documents	= $params->get('link_documents');
		$link_urls 		= $params->get('link_urls');
		$link_targets 	= $params->get('link_targets');
		
		for ($i=0;$i<$count; $i++){
			//Body
			$this->items[$i]->body->source 	= $sources[$i];
			$this->items[$i]->body->html		= $htmls[$i];
			$this->items[$i]->body->joomla_article	= $articles[$i];
			$this->items[$i]->body->joomla_module 	= $modules[$i];
			$this->items[$i]->body->url		= $urls[$i];
			$this->items[$i]->body->query		= $querys[$i];
			
			//Hover panel
			/*
			$this->items[$i]->hover->source 	= $hover_sources[$i];
			$this->items[$i]->hover->html 		= $hover_htmls[$i];
			$this->items[$i]->hover->article 	= $hover_articles[$i];
			$this->items[$i]->hover->module 	= $hover_modules[$i];
			$this->items[$i]->hover->urls 		= $hover_urls[$i];
			$this->items[$i]->hover->query 	= $hover_querys[$i];
			*/
			//Caption
			if (isset($caption_htmls))
				$this->items[$i]->caption->html 	= $caption_htmls[$i];
			
			//Title
			$this->items[$i]->header->label 		= $labels[$i];
			$this->items[$i]->header->glyph->name 		= $glyph_names[$i];
			
			//Link
			$this->items[$i]->link->type		= $link_types[$i];
			if (isset( $link_menus[$i]))
			    $this->items[$i]->link->menu		= $link_menus[$i];
			$this->items[$i]->link->article		= $link_articles[$i];
			$this->items[$i]->link->image		= $link_images[$i];
			$this->items[$i]->link->document	= $link_documents[$i];
			$this->items[$i]->link->url		= $link_urls[$i];
			$this->items[$i]->link->target		= $link_targets[$i];
		}
		
	    }
	    }
	}

	public function add($header, $body, $caption='', $legend='', $link=''){
	    $this->addSource('html', $header, $body, $caption, $legend, $link);
	}
	
	public function addSource($source, $header, $data, $caption='', $legend='', $link=''){
	    $item = new PartThumbnailcustomcontent();
	    $item->header->html 	= $header;
	    $item->hover->html 	= $caption;
	    $item->body->source 	= $source;
	    switch($source){
		case 'html':
		    $item->header->label 	= $header;
		    $item->body->html 	= $data;
		    $item->hover->html 	= $caption;
		    break;
		case 'joomla.article':
		    $item->body->joomla_article 	= $data;
		    break;
		case 'joomla.module':
		    $item->body->joomla_module 	= $data;
		    break;
		default : //html
		    $item->body->html 	= $data;
	    }
	    $this->items[] = $item;
	    $this->count++;
	    
	}
	
	
	
	public function codeWizard($partObject){}
}

