<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/body.php');

require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnailswidth.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnailspacing.php');
require_once(NGEPATH_HELPERS . '/api/imageproperties.php');
require_once(NGEPATH_HELPERS . '/api/multiplebodyheight.php');

/**
 * Thumbnails general class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartThumbnails {

	/**
	 * @var String $mode
	 */
	public $mode;
	/**
	 * @var String $rowitems
	 */
	public $rowitems;
	/**
	 * @var String $css
	 */
	public $css;
	/**
	 * @var PartMultipleBodyHeight $height
	 */
	public $height;
	/**
	 * @var String $margin
	 */
	public $margin;

	/**
	 * @var PartHeader $header
	 */
	public $header;
	/**
	 * @var PartThumbnailsbody $body
	 */
	public $body;
	
	/**   
	 * @var parCaption $caption   
	 * Caption content and options
	 */
	public $caption;

	/**
	 * @var PartLegend $legend
	 */
	public $legend;
	/**
	 * @var PartThumbnailshoverpanel $hoverpanel
	 */
	public $body_hover;
	
	/**   
 	 * @var PartBadge $badge
 	 */
 	public $badge;

	
	/**
	 * @var NgePartImagesProperties $images
	 */
	public $images;

	/**
	 * @var array $effects
	 */
	public $effects;
	
	function __construct(){	
				
		$this->header = 		new PartHeader();
		$this->body =		new PartBody();
		$this->legend =		new PartLegend();
		$this->caption =		new PartCaption();
		$this->badge =		new PartBadge();
			
		$this->width = 		new PartThumbnailsWidth();
		$this->height = 		new PartMultipleBodyHeight();
		$this->spacing = 		new PartThumbnailSpacing();
				
		$this->body_hover =                new PartBody();
		
		//When mode image
		$this->images =		new NgePartImagesImageProperties();
		$this->effects		= array();
	}
	
	public function bind($data){

	    
		if (isset($data->header))			$this->header->bind($data->header);
		if (isset($data->body))			$this->body->bind($data->body);
		if (isset($data->body_hover))			$this->body_hover->bind($data->body_hover);
		
		if (isset($data->legend))			$this->legend->bind($data->legend);
		if (isset($data->caption))			$this->caption->bind($data->caption);
		if (isset($data->badge))			$this->badge->bind($data->badge);
		if (isset($data->width))			$this->width->bind($data->width);
		if (isset($data->height))			$this->height->bind($data->height);
		if (isset($data->spacing))			$this->spacing->bind($data);

		if (isset($data->images))		 	$this->images->bind($data->images);
		
		//display effects on display trigger
		if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->display);
		    $effect->event='display';
		    $this->effects[] = $effect;
		}
		//display effects on hover trigger
		if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action != 'none')){
		    $effect = new PartDisplayEffect();
		    $effect->bind($data->effects->hover);
		    $effect->event='hover';
		    $this->effects[] = $effect;
		}
	}
	
	public function codeWizard($partObject){}
}
