<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Caption class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartThumbnailLayoutContent {    

	/**
	 * @var PartHeaderContent $header
	 */
	public $header;
	
	/**   
 	 * @var PartBadge $badge
 	 */
 	public $badge;
	
	/**   
	 * @var PartCustomContent $body
	 */
	public $body;
	
	/**   
	 * @var PartCustomContent $hover
	 */
	public $hover;

	/**   
	 * @var PartTabsContentGlyph $glyph
	 */
	public $legend;

	/**   
	 * @var PartLink $link
	 */
	public $link;

		
	function __construct(){
		$this->header = '';
		$this->badge = 	'';
		$this->body = 	'';
		$this->hover = 	'';
		$this->legend = "";
	}
	
	public function bind($data){

		if (isset($data->header))	$this->header = $data->header;	
		if (isset($data->badge))	$this->badge = $data->badge;	
		if (isset($data->body))	$this->body = $data->body;	
		if (isset($data->hover))	$this->hover = $data->hover;	
		if (isset($data->legend))	$this->legend = $data->legend;	
	}
	
	public function codeWizard($partObject){}
}