<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnaillayoutcontent.php');

/**
 * Caption class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartThumbnailLayout extends PartBody{    

    	/**
	* @var String $style
	 *  pattern, custom
	 */
	public $mode;

    	
	/**
	 * @var PartThumbnailLayoutContent $builder
	 */
	public $builder;
	
	/**
	 * @var PartThumbnailLayoutContent $template
	 */
	public $template;
	
	
	function __construct($preset = null){

		
		$this->mode = 'auto';
		
		$this->builder = 		new PartThumbnailLayoutContent;
		$this->template = 		new PartThumbnailLayoutContent;
	}
	
	public function bind($data){

	    
		if (isset ( $data->builder))		$this->builder->bind ( $data->builder );
		if (isset ( $data->template))		$this->template->bind ( $data->template );
		
		if (isset ( $data->mode ))		$this->mode = $data->mode ;
	}
	
	public function codeWizard($partObject){}
}
