<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/content/headercontent.php');
require_once(NGEPATH_HELPERS . '/api/content/thumbnails/thumbnailwidth.php');
require_once(NGEPATH_HELPERS . '/api/badge.php');
require_once(NGEPATH_HELPERS . '/api/caption.php');

/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartThumbnailCustomContent{

	/**
	 * @var PartHeaderContent $header
	 */
	public $header;
	
	/**   
 	 * @var PartBadge $badge
 	 */
 	public $badge;
	
	/**   
	 * @var PartCustomContent $body
	 */
	public $body;
	
	/**   
	 * @var PartCustomContent $hover
	 */
	public $hover;

	/**   
	 * @var parCaption $caption   
	 * Caption content and options
	 */
	public $caption;
	
	
	/**   
	 * @var PartTabsContentGlyph $glyph
	 */
	public $legend;

	/**   
	 * @var PartLink $link
	 */
	public $link;

		
	function __construct(){
		$this->header = new PartHeaderContent();
		$this->badge = 	new PartBadge();
		$this->body = 	new PartCustomContent();
		$this->hover = 	new PartCustomContent();
		$this->caption = 	new PartCaption();
		$this->link = 	new PartLink();
		$this->legend = "";
		$this->width = 	new PartThumbnailWidth();
	}
	
	public function bind($data){

		if (isset($data->header))	$this->header->bind($data->header);		
		if (isset($data->badge))	$this->badge->bind($data->badge);
		$this->body->bind($data);
		if (isset($data->hover))	$this->hover->bind($data->hover);
		if (isset($data->caption))	$this->caption->bind($data->caption);
		if (isset($data->link))		$this->link->bind($data->link);
		if (isset($data->legend))	$this->legend = $data->legend;
		if (isset($data->width))	$this->width->bind($data->width);
	}
	
	public function codeWizard($partObject){}
}